@extends('backEnd.master')
@section('title') 
@lang('fees.search_fees_due')
@endsection
@section('mainContent')
@php  $setting = generalSetting(); if(!empty($setting->currency_symbol)){ $currency = $setting->currency_symbol; }else{ $currency = '$'; } @endphp
<section class="sms-breadcrumb mb-40 white-box">
    <div class="container-fluid">
        <div class="row justify-content-between">
            <h1>@lang('fees.search_fees_due')</h1>
            <div class="bc-pages">
                <a href="{{route('dashboard')}}">@lang('common.dashboard')</a>
                <a href="#">@lang('fees.fees_collection')</a>
                <a href="#">@lang('fees.search_fees_due')</a>
            </div>
        </div>
    </div>
</section>
<section class="admin-visitor-area">
    <div class="container-fluid p-0">
            <div class="row">
                <div class="col-lg-4 col-md-6">
                    <div class="main-title">
                        <h3 class="mb-30">@lang('common.select_criteria') </h3>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-12">
                  
                    <div class="white-box">
                        {{ Form::open(['class' => 'form-horizontal', 'files' => true, 'route' => 'fees_due_search', 'method' => 'POST', 'enctype' => 'multipart/form-data', 'id' => 'search_student']) }}
                            <div class="row">
                                <input type="hidden" name="url" id="url" value="{{URL::to('/')}}">
                                <div class="col-lg-4 mt-30-md">
                                    <select class="w-100 bb niceSelect form-control {{ $errors->has('fees_group') ? ' is-invalid' : '' }}" name="fees_group">
                                        <option data-display="@lang('fees.fees_group')*" value="">@lang('fees.fees_group') *</option>
                                        @foreach($fees_masters as $fees_master)
                                            <option value="" disabled>{{@$fees_master->feesGroups->name}}</option>
                                             @foreach($fees_master->feesTypeIds as $feesTypeId)
                                                <option value="{{$fees_master->fees_group_id.'-'.$feesTypeId->feesTypes->id}}" {{isset($fees_group_id)? ($fees_group_id == $feesTypeId->feesTypes->id? 'selected':''):''}}>{{$feesTypeId->feesTypes->name}}</option>
                                             @endforeach
                                        @endforeach
                                    </select>
                                    @if ($errors->has('fees_group'))
                                    <span class="invalid-feedback invalid-select" role="alert">
                                        <strong>{{ $errors->first('fees_group') }}</strong>
                                    </span>
                                    @endif
                                </div>
                                <div class="col-lg-4 mt-30-md">
                                    <select class="w-100 bb niceSelect form-control {{ $errors->has('class') ? ' is-invalid' : '' }}" id="select_class" name="class">
                                        <option data-display="@lang('common.select_class') *" value="">@lang('common.select_class') *</option>
                                        @foreach($classes as $class)
                                        <option value="{{$class->id}}" {{isset($class_id)? ($class_id == $class->id? 'selected':''):''}}>{{$class->class_name}}</option>
                                        @endforeach
                                    </select>
                                    @if ($errors->has('class'))
                                    <span class="invalid-feedback invalid-select" role="alert">
                                        <strong>{{ $errors->first('class') }}</strong>
                                    </span>
                                    @endif
                                </div>
                                <div class="col-lg-4 mt-30-md" id="select_section_div">
                                    <select class="w-100 bb niceSelect form-control{{ $errors->has('section') ? ' is-invalid' : '' }}" id="select_section" name="section">
                                        <option data-display="@lang('common.select_section')" value="">@lang('common.select_section')</option>
                                    </select>
                                    <div class="pull-right loader loader_style" id="select_section_loader">
                                        <img class="loader_img_style" src="{{asset('public/backEnd/img/demo_wait.gif')}}" alt="loader">
                                    </div>
                                    @if ($errors->has('section'))
                                    <span class="invalid-feedback invalid-select" role="alert">
                                        <strong>{{ $errors->first('section') }}</strong>
                                    </span>
                                    @endif
                                </div>
                                <div class="col-lg-12 mt-20 text-right">
                                    <button type="submit" class="primary-btn small fix-gr-bg">
                                        <span class="ti-search pr-2"></span>
                                        @lang('common.search')
                                    </button>
                                </div>
                            </div>
                        {{ Form::close() }}
                    </div>
                </div>
            </div>
            
        {{-- @if(isset($fees_dues)) --}}



             {{ Form::open(['class' => 'form-horizontal', 'files' => true, 'route' => 'send-dues-fees-email', 'method' => 'POST', 'enctype' => 'multipart/form-data', 'id' => 'search_student']) }}

            <div class="row mt-40">
                <div class="col-lg-12">
                    <div class="row">
                    <div class="col-12">
                        <div class="main-title d-flex align-items-center flex-wrap mb_sm_75">
                            <h3 class="mb-0 mb-2 mt-2 mr-2"> @lang('fees.fees_due_list')</h3>
                            <div class="fes_lag_btn d-flex align-items-center">
                                <button name="send_email" type="submit" class="primary-btn small fix-gr-bg mr-2">
                                    <span class="ti-envelope pr-2"></span>
                                    @lang('communicate.send_email')
                                </button>
                                <button name="send_sms" type="submit" class="primary-btn small fix-gr-bg ">
                                    <span class="ti-envelope pr-2"></span>
                                    @lang('communicate.send_sms')
                                </button>
                            </div>
                        </div>
                    </div>
                    
                    </div>
                    <div class="row">
                        <div class="col-lg-12 search_hide_md">

                            <table id="table_id" class="display school-table " cellspacing="0" width="100%">

                                <thead>
                                    <tr>
                                        <th> @lang('student.admission_no')</th>
                                        <th> @lang('student.roll_no')</th>
                                        <th> @lang('common.name')</th>
                                        {{-- <th> @lang('common.date_of_birth')</th> --}}
                                        <th>@lang('fees.due_date')</th>
                                        <th>@lang('fees.amount') ({{generalSetting()->currency_symbol}})</th>
                                        <th>@lang('fees.deposit') ({{generalSetting()->currency_symbol}})</th>
                                        <th>@lang('fees.discount') ({{generalSetting()->currency_symbol}})</th>
                                        <th>@lang('fees.fine') ({{generalSetting()->currency_symbol}})</th>
                                        <th>@lang('fees.balance') ({{generalSetting()->currency_symbol}})</th>
                                        <th>@lang('common.action')</th>
                                    </tr>
                                </thead>

                                <tbody>
                                @foreach($fees_dues as $fees_due)
                                    {{-- <input type="text" name="student_list[]" value="{{$fees_due->studentInfo->id}}">
                                    <input type="hidden" name="fees_master" value="{{$fees_due->feesGroupMaster->id}}"> --}}
                                    <tr>
                                        <td>{{$fees_due->studentInfo !=""?$fees_due->studentInfo->admission_no:""}}</td>
                                        <td>{{$fees_due->studentInfo !=""?$fees_due->studentInfo->roll_no:""}}</td>
                                        <td>{{$fees_due->studentInfo !=""?$fees_due->studentInfo->full_name:""}}</td>
                                        {{-- <td>
                                            @if($fees_due->studentInfo !="")
                                           {{$fees_due->studentInfo->date_of_birth != ""? dateConvert($fees_due->studentInfo->date_of_birth):''}}
                                            @endif
                                        </td> --}}
                                        <td>
                                            @if($fees_due->feesGroupMaster !="")

                                                {{$fees_due->feesGroupMaster->date != ""? dateConvert($fees_due->feesGroupMaster->date):''}}

                                            @endif
                                        </td>
                                        <td>
                                            @php
                                                echo $fees_due->feesGroupMaster->amount;


                                            @endphp
                                        </td>
                                        <td>
                                            @php
                                                $amount = App\SmFeesAssign::discountSum($fees_due->student_id, $fees_due->feesGroupMaster->feesTypes->id, 'amount');
                                                echo $amount;
                                            @endphp
                                        </td>
                                        <td>
                                            @php
                                                $discount_amount = $fees_due->applied_discount;
                                                if ($discount_amount>0) {
                                                    echo $discount_amount;
                                                } else {
                                                   echo 0.00;
                                                }

                                            @endphp
                                        </td>
                                        <td>
                                            @php
                                                $fine = App\SmFeesAssign::discountSum($fees_due->student_id, $fees_due->feesGroupMaster->feesTypes->id, 'fine');
                                                echo $fine;
                                            @endphp
                                        </td>
                                        <td>
                                            @php
                                                echo $fees_due->feesGroupMaster->amount - $discount_amount - $amount+$fine;
                                                 $dues_amount = $fees_due->feesGroupMaster->amount - $discount_amount - $amount;


                                            @endphp
                                            <input type="hidden" name="dues_amount[{{$fees_due->studentInfo->id}}]" value="{{$dues_amount}}">
                                            <input type="hidden" name="student_list[]" value="{{$fees_due->studentInfo->id}}">
                                            <input type="hidden" name="fees_master" value="{{$fees_due->feesGroupMaster->id}}">
                                        </td>
                                        <td><div class="dropdown">
                                                <button type="button" class="btn dropdown-toggle" data-toggle="dropdown">
                                                    @lang('lang.select')
                                                </button>


                                                @if(userPermission(117))



                                                    <div class="dropdown-menu dropdown-menu-right">
                                                        <a class="dropdown-item" href="{{route('fees_collect_student_wise', [$fees_due->student_id])}}">@lang('lang.view')</a>
                                                    </div>

                                                @endif
                                            </div>
                                        </td>
                                    </tr>
                                @endforeach
                                   
                                </tbody>
                            </table>
                        </div>
                    </div> 
                </div>
            </div>
            {{ Form::close() }}

{{-- @endif --}}

    </div>
</section>


@endsection
