<?php $__env->startSection('title'); ?>
    <?php echo app('translator')->get('fees.bank_payment'); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('mainContent'); ?>
    <?php $__env->startPush('css'); ?>
        <style>
            table.dataTable.row-border tbody th, table.dataTable.row-border tbody td, table.dataTable.display tbody th, table.dataTable.display tbody td {
                border-bottom: 1px solid rgba(130, 139, 178, 0.15) !important;
            }
        </style>
    <?php $__env->stopPush(); ?>
    <section class="sms-breadcrumb mb-40 white-box up_breadcrumb">
        <div class="container-fluid">
            <div class="row justify-content-between">
                <h1><?php echo app('translator')->get('fees.bank_payment'); ?></h1>
                <div class="bc-pages">
                    <a href="<?php echo e(route('dashboard')); ?>"><?php echo app('translator')->get('common.dashboard'); ?></a>
                    <a href="#"><?php echo app('translator')->get('fees.fees_collection'); ?></a>
                    <a href="#"><?php echo app('translator')->get('fees.bank_payment'); ?></a>
                </div>
            </div>
        </div>
    </section>

    <section class="admin-visitor-area up_admin_visitor">
        <div class="container-fluid p-0">
            <div class="row">
                <div class="col-lg-6 col-md-6 col-sm-6">
                    <div class="main-title mt_0_sm mt_0_md">
                        <h3 class="mb-30"><?php echo app('translator')->get('common.select_criteria'); ?> </h3>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-12">
                    <div class="white-box">
                        <?php echo e(Form::open(['class' => 'form-horizontal', 'files' => true, 'route' => 'fees.search-bank-payment', 'method' => 'post'])); ?>

                        <div class="row">
                            <input type="hidden" name="url" id="url" value="<?php echo e(URL::to('/')); ?>">
                            <div class="col-lg-3 col-md-3 sm_mb_20 sm2_mb_20">
                                <select class="niceSelect w-100 bb form-control<?php echo e($errors->has('class') ? ' is-invalid' : ''); ?>" id="select_class" name="class">
                                    <option data-display="<?php echo app('translator')->get('common.select_class'); ?>" value=""><?php echo app('translator')->get('common.select_class'); ?></option>
                                    <?php $__currentLoopData = $classes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $class): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($class->id); ?>" <?php echo e(isset($class_id)? ($class_id == $class->id? 'selected': ''):''); ?>><?php echo e($class->class_name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <?php if($errors->has('class')): ?>
                                    <span class="invalid-feedback invalid-select" role="alert">
                                        <strong><?php echo e($errors->first('class')); ?></strong>
                                    </span>
                                <?php endif; ?>
                            </div>
                            <div class="col-lg-3 col-md-3" id="select_section_div">
                                <select class="niceSelect w-100 bb form-control<?php echo e($errors->has('section') ? ' is-invalid' : ''); ?>" id="select_section" name="section">
                                    <option data-display="<?php echo app('translator')->get('common.select_section'); ?>" value=""><?php echo app('translator')->get('common.select_section'); ?></option>
                                    <?php if(isset($section_id)): ?>
                                        <?php $__currentLoopData = $sections; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $section): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($section->id); ?>" <?php echo e(isset($section_id)? ($section_id == $section->id? 'selected': ''):''); ?>><?php echo e($section->section_name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>
                                </select>
                                <div class="pull-right loader loader_style" id="select_section_loader">
                                    <img class="loader_img_style" src="<?php echo e(asset('public/backEnd/img/demo_wait.gif')); ?>" alt="loader">
                                </div>
                                <?php if($errors->has('section')): ?>
                                    <span class="invalid-feedback invalid-select" role="alert">
                                        <strong><?php echo e($errors->first('section')); ?></strong>
                                    </span>
                                <?php endif; ?>
                            </div>
                            <div class="col-lg-3 col-md-3 mt-30-md">
                                <div class="row no-gutters input-right-icon">
                                    <div class="col">
                                        <div class="input-effect">
                                            <input class="primary-input date form-control<?php echo e($errors->has('payment_date') ? ' is-invalid' : ''); ?> <?php echo e(isset($date)? 'read-only-input': ''); ?>" id="startDate" type="text"
                                                   name="payment_date" autocomplete="off" value="<?php echo e(isset($date)? $date: ''); ?>">
                                            <label for="startDate"><?php echo app('translator')->get('fees.payment_date'); ?></label>
                                            <span class="focus-border"></span>
                                            <?php if($errors->has('payment_date')): ?>
                                                <span class="invalid-feedback" role="alert">
                                                    <strong><?php echo e($errors->first('payment_date')); ?></strong>
                                                </span>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                    <div class="col-auto">
                                        <button class="" type="button">
                                            <i class="ti-calendar" id="start-date-icon"></i>
                                        </button>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-3 col-md-3 sm_mb_20 sm2_mb_20">
                                <select class="niceSelect w-100 bb form-control<?php echo e($errors->has('approve_status') ? ' is-invalid' : ''); ?>" name="approve_status">
                                    <option data-display="<?php echo app('translator')->get('common.status'); ?>" value=""><?php echo app('translator')->get('common.status'); ?></option>
                                    <option value="pending" <?php echo e(isset($approve_status)? ($approve_status == 'pending'? 'selected': ''):''); ?>><?php echo app('translator')->get('common.pending'); ?></option>
                                    <option value="approve" <?php echo e(isset($approve_status)? ($approve_status == 'approve'? 'selected': ''):''); ?>><?php echo app('translator')->get('common.approved'); ?></option>
                                    <option value="reject" <?php echo e(isset($approve_status)? ($approve_status == 'reject'? 'selected': ''):''); ?>><?php echo app('translator')->get('common.reject'); ?></option>
                                </select>
                                <?php if($errors->has('approve_status')): ?>
                                    <span class="invalid-feedback invalid-select" role="alert">
                                        <strong><?php echo e($errors->first('approve_status')); ?></strong>
                                    </span>
                                <?php endif; ?>
                            </div>
                            <div class="col-lg-12 mt-20 text-right">
                                <?php if(userPermission(1149) ): ?>
                                    <button type="submit" class="primary-btn small fix-gr-bg">
                                        <span class="ti-search pr-2"></span>
                                        <?php echo app('translator')->get('common.search'); ?>
                                    </button>
                                <?php endif; ?>
                            </div>
                        </div>
                        <?php echo e(Form::close()); ?>

                    </div>
                </div>
            </div>


            <div class="row mt-40">
                <div class="col-lg-12">
                    <div class="row">
                        <div class="col-lg-4 no-gutters">
                            <div class="main-title">
                                <h3 class="mb-0">  <?php echo app('translator')->get('fees.bank_payment_list'); ?></h3>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-lg-12">
                            <table id="table_id" class="display school-table " cellspacing="0" width="100%">
                                <thead>
                                <tr>
                                    <th><?php echo app('translator')->get('student.student_name'); ?></th>
                                    <th><?php echo app('translator')->get('fees::feesModule.view_transcation'); ?></th>
                                    <th><?php echo app('translator')->get('common.date'); ?></th>
                                    <th><?php echo app('translator')->get('fees::feesModule.amount'); ?></th>
                                    <th><?php echo app('translator')->get('common.note'); ?></th>
                                    <th><?php echo app('translator')->get('common.file'); ?></th>
                                    <th><?php echo app('translator')->get('common.status'); ?></th>
                                    <th><?php echo app('translator')->get('common.actions'); ?></th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php if( isset($feesPayments)): ?>

                                    <?php $__currentLoopData = $feesPayments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bank_payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php
                                            $paid_amount = $bank_payment->PaidAmount;
                                        ?>
                                        <tr>
                                            <td><?php echo e(@$bank_payment->feeStudentInfo->full_name); ?></td>

                                            <td>
                                                <a class="text-color" data-toggle="modal" data-target="#showTranscation<?php echo e($bank_payment->id); ?>"  href="#"><?php echo app('translator')->get('common.details'); ?></a>
                                                <div class="modal fade admin-query" id="showTranscation<?php echo e($bank_payment->id); ?>">
                                                    <div class="modal-dialog modal-dialog-centered large-modal">
                                                        <div class="modal-content">
                                                            <div class="modal-header">
                                                                <h4 class="modal-title"><?php echo app('translator')->get('fees::feesModule.payment_method'); ?> : <?php echo e($bank_payment->payment_method); ?></h4>
                                                                <button type="button" class="close" data-dismiss="modal">&times;</button>
                                                            </div>
                                                            <div class="modal-body p-0 mt-30">
                                                                <div class="container student-certificate">
                                                                    <div class="row justify-content-center">
                                                                        <div class="col-lg-12 text-center">
                                                                            <table class="display school-table school-table-style shadow-done" cellspacing="0" width="100%">
                                                                                <thead>
                                                                                <tr>
                                                                                    <th><?php echo app('translator')->get('fees::feesModule.fees_type'); ?></th>
                                                                                    <th><?php echo app('translator')->get('fees::feesModule.paid_amount'); ?></th>
                                                                                </tr>
                                                                                </thead>
                                                                                <tbody>
                                                                                    <?php $__currentLoopData = $bank_payment->transcationDetails; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $details): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                                            <tr>
                                                                                                <td><?php echo e(@$details->transcationFeesType->name); ?></td>
                                                                                                <td><?php echo e(@$details->paid_amount); ?></td>
                                                                                            </tr>
                                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                                    <?php if(@$bank_payment->add_wallet_money > 0): ?>
                                                                                        <tr>
                                                                                            <td><strong><?php echo app('translator')->get('fees::feesModule.wallet_money'); ?></strong></td>
                                                                                            <td><strong><?php echo e($bank_payment->add_wallet_money); ?></strong></td>
                                                                                        </tr>
                                                                                    <?php endif; ?>
                                                                                </tbody>
                                                                            </table>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                            </td>
                                            <td><?php echo e(dateConvert($bank_payment->created_at)); ?></td>
                                            <td><?php echo e($paid_amount + $bank_payment->add_wallet_money); ?></td>
                                            <td>
                                                <a class="text-color" data-toggle="modal" data-target="#showNote<?php echo e($bank_payment->id); ?>"  href="#"><?php echo app('translator')->get('common.note'); ?></a>
                                            </td>
                                            <td>
                                                <?php if(!empty($bank_payment->file)): ?>
                                                    <a class="text-color" data-toggle="modal" data-target="#bankPaymentFile<?php echo e($bank_payment->id); ?>"  href="#"><?php echo app('translator')->get('common.file'); ?></a>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <?php if($bank_payment->paid_status=='pending'): ?>
                                                    <button class="primary-btn small bg-warning text-white border-0"><?php echo app('translator')->get('common.pending'); ?></button>
                                                <?php elseif($bank_payment->paid_status=='approve'): ?>
                                                    <button class="primary-btn small bg-success text-white border-0  tr-bg"><?php echo app('translator')->get('common.approved'); ?></button>
                                                <?php else: ?>
                                                    <button class="primary-btn small bg-danger text-white border-0"><?php echo app('translator')->get('common.reject'); ?></button>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <div class="dropdown">
                                                    <button type="button" class="btn dropdown-toggle" data-toggle="dropdown">
                                                        <?php echo app('translator')->get('common.select'); ?>
                                                    </button>
                                                    <div class="dropdown-menu dropdown-menu-right">
                                                        <?php if($bank_payment->paid_status=='pending'): ?>
                                                            <?php if(userPermission(1150) ): ?>
                                                                <a onclick="enableId(<?php echo e($bank_payment->id); ?>);" class="dropdown-item" href="#" data-toggle="modal" data-target="#approvePayment" data-id="<?php echo e($bank_payment->id); ?>">
                                                                    <?php echo app('translator')->get('common.approve'); ?>
                                                                </a>
                                                            <?php endif; ?>
                                                            <?php if(userPermission(1151) ): ?>
                                                                <a onclick="rejectPayment(<?php echo e($bank_payment->id); ?>);" class="dropdown-item" href="#" data-toggle="modal" data-id="<?php echo e($bank_payment->id); ?>">
                                                                    <?php echo app('translator')->get('accounts.reject'); ?>
                                                                </a>
                                                            <?php endif; ?>
                                                        <?php endif; ?>
                                                    </div>
                                                </div>
                                            </td>
                                        </tr>


                                        <div class="modal fade admin-query" id="showNote<?php echo e($bank_payment->id); ?>">
                                            <div class="modal-dialog modal-dialog-centered large-modal">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h4 class="modal-title"><?php echo app('translator')->get('fees.note'); ?></h4>
                                                        <button type="button" class="close" data-dismiss="modal">&times;</button>
                                                    </div>
                                                    <div class="modal-body p-0 mt-30">
                                                        <div class="container student-certificate">
                                                            <div class="row justify-content-center">
                                                                <div class="col-lg-12 text-center">
                                                                    <p><?php echo e($bank_payment->payment_note); ?></p>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="modal fade admin-query" id="bankPaymentFile<?php echo e($bank_payment->id); ?>">
                                            <div class="modal-dialog modal-dialog-centered large-modal">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h4 class="modal-title"><?php echo app('translator')->get('fees.file'); ?></h4>
                                                        <button type="button" class="close" data-dismiss="modal">&times;</button>
                                                    </div>
                                                    <div class="modal-body p-0 mt-30">
                                                        <div class="container student-certificate">
                                                            <div class="row justify-content-center">
                                                                <div class="col-lg-12 text-center">

                                                                    <?php
                                                                        $pdf = $bank_payment->file ? explode('.', $bank_payment->file) : [];
                                                                        $for_pdf =  $pdf[1]?? null;
                                                                    ?>
                                                                    <?php if(@$for_pdf=="pdf"): ?>
                                                                        <div class="mb-5">
                                                                            <a href="<?php echo e(asset($bank_payment->file)); ?>" download><?php echo app('translator')->get('common.download'); ?> <span class="pl ti-download"></span></a>
                                                                        </div>
                                                                    <?php else: ?>
                                                                        <div class="mb-5">
                                                                            <img class="img-fluid" src="<?php echo e(asset($bank_payment->file)); ?>">
                                                                            </br>
                                                                            <a href="<?php echo e(asset($bank_payment->file)); ?>" download><?php echo app('translator')->get('common.download'); ?> <span class="pl ti-download"></span></a>
                                                                        </div>
                                                                    <?php endif; ?>

                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <div class="modal fade admin-query" id="approvePayment" >
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title"><?php echo app('translator')->get('fees::feesModule.approve_payment'); ?></h4>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>

                <div class="modal-body">
                    <div class="text-center">
                        <h4><?php echo app('translator')->get('fees.are_you_sure_to_approve'); ?></h4>
                    </div>
                    <div class="mt-40 d-flex justify-content-between">
                        <button type="button" class="primary-btn tr-bg" data-dismiss="modal"><?php echo app('translator')->get('common.cancel'); ?></button>
                        <?php echo e(Form::open(['route' => 'fees.approve-bank-payment', 'method' => 'POST'])); ?>

                        <input type="hidden" name="transcation_id" value="<?php echo e(@$bank_payment->id); ?>">
                        <button class="primary-btn fix-gr-bg" type="submit"><?php echo app('translator')->get('common.approve'); ?></button>
                        <?php echo e(Form::close()); ?>

                    </div>
                </div>

            </div>
        </div>
    </div>


    <!-- modal start here  -->

    <div class="modal fade admin-query" id="rejectPaymentModal" >
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title"><?php echo app('translator')->get('fees::feesModule.bank_payment_reject'); ?> </h4>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>
                <div class="modal-body">
                    <div class="text-center">
                        <h4><?php echo app('translator')->get('fees::feesModule.are_you_sure_to_reject'); ?></h4>
                    </div>
                    <?php echo e(Form::open(['route' => 'fees.reject-bank-payment', 'method' => 'POST'])); ?>

                    <div class="form-group">
                        <input type="hidden" name="transcation_id" value="<?php echo e(@$bank_payment->id); ?>">
                        <label><strong><?php echo app('translator')->get('fees::feesModule.reject_note'); ?></strong></label>
                        <textarea name="payment_reject_reason" class="form-control" rows="6"></textarea>
                    </div>

                    <div class="mt-40 d-flex justify-content-between">
                        <button type="button" class="primary-btn tr-bg" data-dismiss="modal"><?php echo app('translator')->get('common.close'); ?></button>
                        <button class="primary-btn fix-gr-bg" type="submit"><?php echo app('translator')->get('common.submit'); ?></button>
                    </div>
                    <?php echo e(Form::close()); ?>


                </div>

            </div>
        </div>
    </div>

    <div class="modal fade admin-query" id="showReasonModal" >
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title"><?php echo app('translator')->get('lang.reject_note'); ?></h4>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <label><strong><?php echo app('translator')->get('lang.reject_note'); ?></strong></label>
                        <textarea readonly class="form-control" rows="4"></textarea>
                    </div>
                    <div class="mt-40 d-flex justify-content-between">
                        <button type="button" class="primary-btn fix-gr-bg" data-dismiss="modal">Close</button>
                    </div>
                </div>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>
<?php if(! isset($feesPayments)): ?>
<?php $__env->startSection('script'); ?>
    <?php echo $__env->make('backEnd.partials.server_side_datatable', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <script>
        //
        // DataTables initialisation
        //
        $(document).ready(function() {
            $('.data-table').DataTable({
                processing: true,
                serverSide: true,
                "ajax": $.fn.dataTable.pipeline( {
                    url: "<?php echo e(url('bank-payment-slip-ajax')); ?>",
                    data: {
                        academic_year: $('#academic_id').val(),
                        class: $('#class').val(),
                        section: $('#section').val(),
                        roll_no: $('#roll').val(),
                        name: $('#name').val()
                    },
                    pages: "<?php echo e(generalSetting()->ss_page_load); ?>" // number of pages to cache

                } ),
                columns: [
                    {data: 'student_info.full_name', name: 'student_name'},
                    {data: 'fees_type.name', name: 'fees_type'},
                    {data: 'date', name: 'date'},
                    {data: 'amount', name: 'amount'},
                    {data: 'note', name: 'note'},
                    {data: 'slip', name: 'slip'},
                    {data: 'status', name: 'status'},
                    {data: 'action', name: 'action',orderable: false, searchable: true},

                ],
                bLengthChange: false,
                bDestroy: true,
                language: {
                    search: "<i class='ti-search'></i>",
                    searchPlaceholder: window.jsLang('quick_search'),
                    paginate: {
                        next: "<i class='ti-arrow-right'></i>",
                        previous: "<i class='ti-arrow-left'></i>",
                    },
                },
                dom: "Bfrtip",
                buttons: [{
                    extend: "copyHtml5",
                    text: '<i class="fa fa-files-o"></i>',
                    title: $("#logo_title").val(),
                    titleAttr: window.jsLang('copy_table'),
                    exportOptions: {
                        columns: ':visible:not(.not-export-col)'
                    },
                },
                    {
                        extend: "excelHtml5",
                        text: '<i class="fa fa-file-excel-o"></i>',
                        titleAttr: window.jsLang('export_to_excel'),
                        title: $("#logo_title").val(),
                        margin: [10, 10, 10, 0],
                        exportOptions: {
                            columns: ':visible:not(.not-export-col)'
                        },
                    },
                    {
                        extend: "csvHtml5",
                        text: '<i class="fa fa-file-text-o"></i>',
                        titleAttr: window.jsLang('export_to_csv'),
                        exportOptions: {
                            columns: ':visible:not(.not-export-col)'
                        },
                    },
                    {
                        extend: "pdfHtml5",
                        text: '<i class="fa fa-file-pdf-o"></i>',
                        title: $("#logo_title").val(),
                        titleAttr: window.jsLang('export_to_pdf'),
                        exportOptions: {
                            columns: ':visible:not(.not-export-col)'
                        },
                        orientation: "landscape",
                        pageSize: "A4",
                        margin: [0, 0, 0, 12],
                        alignment: "center",
                        header: true,
                        customize: function(doc) {
                            doc.content[1].margin = [100, 0, 100, 0]; //left, top, right, bottom
                            doc.content.splice(1, 0, {
                                margin: [0, 0, 0, 12],
                                alignment: "center",
                                image: "data:image/png;base64," + $("#logo_img").val(),
                            });
                        },
                    },
                    {
                        extend: "print",
                        text: '<i class="fa fa-print"></i>',
                        titleAttr: window.jsLang('print'),
                        title: $("#logo_title").val(),
                        exportOptions: {
                            columns: ':visible:not(.not-export-col)'
                        },
                    },
                    {
                        extend: "colvis",
                        text: '<i class="fa fa-columns"></i>',
                        postfixButtons: ["colvisRestore"],
                    },
                ],
                columnDefs: [{
                    visible: false,
                }, ],
                responsive: true,
            });
        } );
    </script>
<?php $__env->stopSection(); ?>
<?php endif; ?>
<?php $__env->startPush('script'); ?>
    <script>
        function rejectPayment(id){
            var modal = $('#rejectPaymentModal');
            modal.find('#showId').val(id)
            modal.modal('show');

        }
        function viewReason(id){
            var reason = $('.reason'+ id).data('reason');
            var modal = $('#showReasonModal');
            modal.find('textarea').val(reason)
            modal.modal('show');
        }
    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('backEnd.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/webdevia/domains/webdevian.com/public_html/umsnew/Modules/Fees/Resources/views/bankPayment.blade.php ENDPATH**/ ?>